<p align="center">
    <img src="logo.png" alt="Kaeferjaeger" width="50%">
</p>

---

## Usage

#### A-record

If you want to get a record that resolves to an IP, use the following subdomain:

`make-<IP>-rr.rebind.kaeferjaeger.gay`

For example, domain `make-1.2.3.4-rr.rebind.kaeferjaeger.gay` resolves to `1.2.3.4`:

```shell
$ host -t A make-1.2.3.4-rr.rebind.kaeferjaeger.gay
make-1.2.3.4-rr.rebind.kaeferjaeger.gay has address 1.2.3.4
```

You can use dashes instead of dots as long as the IP is valid:

```shell
$ host -t A make-1-2-3-4-rr.rebind.kaeferjaeger.gay
make-1-2-3-4-rr.rebind.kaeferjaeger.gay has address 1.2.3.4
```

You can place some unique prefix/suffix before `make` or after `rr` (dots are allowed):

```shell
$ host -t A a.prefix-make-1-2-3-4-rr-and.a-suffix.rebind.kaeferjaeger.gay
a.prefix-make-1-2-3-4-rr-and.a-suffix.rebind.kaeferjaeger.gay has address 1.2.3.4
```

Multiple records can be separated by `-and-`:

```shell
$ host -t A make-1-2-3-4-and-5-6-7-8-rr.rebind.kaeferjaeger.gay
make-1-2-3-4-and-5-6-7-8-rr.rebind.kaeferjaeger.gay has address 1.2.3.4
make-1-2-3-4-and-5-6-7-8-rr.rebind.kaeferjaeger.gay has address 5.6.7.8
```

#### DNS rebinding

In the context of SSRF bugs, DNS rebinding is a well-known technique targeting TOCTOU type of vulnerabilities during IP blacklisting or whitelisting. It is performed using a domain that resolves in a legit IP during the first request (check) and to the forbidden one during the second request (use).

To generate a domain name with this behavior, use the following syntax:

`make-<IP1>-rebind-<IP2>-rr.rebind.kaeferjaeger.gay`

For example, the domain name `make-1.2.3.4-rebind-169.254-169.254-rr.rebind.kaeferjaeger.gay` will first resolve to `1.2.3.4` and then to `169.254.169.254`:

```shell
$ host -t A make-1.2.3.4-rebind-169.254-169.254-rr.rebind.kaeferjaeger.gay
make-1.2.3.4-rebind-169.254-169.254-rr.rebind.kaeferjaeger.gay has address 1.2.3.4
$ host -t A make-1.2.3.4-rebind-169.254-169.254-rr.rebind.kaeferjaeger.gay
make-1.2.3.4-rebind-169.254-169.254-rr.rebind.kaeferjaeger.gay has address 169.254.169.254
```

The logic behind the feature is as follows:
* if there were no requests to this domain during last 5 seconds, it's resolved to the first IP;
* otherwise, it's resolved to the second one.

You can use prefixes before `make-` and suffix after `-rr` in order to uniqualize the domain name (e.g. `prefix-make-1.2.3.4-rebind-169.254-169.254-rr-suffix.rebind.kaeferjaeger.gay`). The timeouts are separate for each domain name.

If you need to change the default 5 seconds timeout, use the following syntax:

`make-<IP1>-rebindfor<interval>-<IP2>-rr.rebind.kaeferjaeger.gay`

where `<interval>` is something like `10s` (10 seconds) or `5m` (5 minutes).

If you need that "whitelisted" IP (which is IP1 in our examples) be returned multiple times before rebinding, use the following syntax:

`make-<IP1>-rebindfor<interval>after<num>times-<IP2>-rr.rebind.kaeferjaeger.gay`

For example, `make-1.2.3.4-rebindfor30safter2times-127.0.0.1-rr.rebind.kaeferjaeger.gay` will resolve in `1.2.3.4` first two times, and then will resolve in `127.0.0.1` for next 30 seconds.

#### AAAA-record

To make up a domain that resolves only to an IPv6 address, use the following syntax:

`make-ip-v6-<IP>-rr.rebind.kaeferjaeger.gay`

Colons must be replaced with letter `c`. As always, random prefix and suffix can be used:

```shell
$ host -t AAAA prefix-make-ip-v6-1c2cc3-rr-suffix.rebind.kaeferjaeger.gay
prefix-make-ip-v6-1c2cc3-rr-suffix.rebind.kaeferjaeger.gay has IPv6 address 1:2::3
```

#### CNAMEs

By default, unparsable addresses are considered as CNAMEs:

```shell
$ host make-example.com-rr.rebind.kaeferjaeger.gay
make-example.com-rr.rebind.kaeferjaeger.gay is an alias for example.com.
...
```

To force a domain to be a CNAME, add `cname-` prefix:

```shell
$ host -t A make-cname-example.com-rr.rebind.kaeferjaeger.gay
make-cname-example.com-rr.rebind.kaeferjaeger.gay is an alias for example.com.
...
```

#### Other record types

If the thing between `make-` and `-rr` is a parsable record, it is returned for any type of request.

```shell
$ host -t TXT make-blahblah-rr.rebind.kaeferjaeger.gay
make-blahblah-rr.rebind.kaeferjaeger.gay descriptive text "blahblah"
```

#### Hex encoding

You can encode the contents of a record in hex and add a `hex-` prefix after `make-`:

```shell
$ host -t A make-hex-312e322e332e34-rr.rebind.kaeferjaeger.gay
make-hex-312e322e332e34-rr.rebind.kaeferjaeger.gay has address 1.2.3.4
```

#### Note on DNS TTLs

Some servers don't want to handle zero TTL replies. Default TTL is 1 for "service" domains and 0 for others.

If you want to change TTL, add `set-<number>-ttl` anywhere in the domain name.

---------------
In 💖 with <a href="https://twitter.com/search?q=%23kaeferjaeger" target="_blank">Kaeferjaeger</a>.

<style>
.styled-table {
    border-collapse: collapse;
    margin: 25px 0;
    min-width: 100%;
    box-shadow: 0 0 20px rgba(0, 0, 0, 0.15);
}
.styled-table thead tr {
    background-color: #000000;
    color: #ffffff;
    text-align: left;
}
.styled-table th,
.styled-table td {
    padding: 12px 15px;
}
.styled-table tbody tr {
    border-bottom: 1px solid #dddddd;
}

.styled-table tbody tr.active-row {
    font-weight: bold;
    color: #009879;
}

table ul li {
    list-style: none;
}

</style>
