# IPRanges

![IP Ranges](logo.png)

List all IP ranges from: Google (Cloud & GoogleBot), Bing (Bingbot), Amazon (AWS), Microsoft, Oracle (Cloud), DigitalOcean, GitHub, Facebook (Meta), Twitter, Linode, Telegram, OpenAI (GPTBot), CloudFlare, Vultr, Apple (Private Relay) and ProtonVPN with daily updates.

All lists are obtained from public sources.

## List types

`ipv4.txt`/`ipv6.txt` – the list of addresses (IPv4 or IPv6), which is the result of parsing one or more sources.

`ipv4_merged.txt`/`ipv6_merged.txt` – list of addresses, after combining them into the smallest possible list of CIDRs.

## Download links

All addresses are stored in `.txt` files with CIDRs, where each range is on a new line.

### Google (Cloud & GoogleBot)

- IPv4: https://raw.githubusercontent.com/lord-alfred/ipranges/main/google/ipv4.txt
- IPv4 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/google/ipv4_merged.txt
- IPv6: https://raw.githubusercontent.com/lord-alfred/ipranges/main/google/ipv6.txt
- IPv6 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/google/ipv6_merged.txt

### Google (GoogleBot)

- IPv4: https://raw.githubusercontent.com/lord-alfred/ipranges/main/googlebot/ipv4.txt
- IPv4 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/googlebot/ipv4_merged.txt
- IPv6: https://raw.githubusercontent.com/lord-alfred/ipranges/main/googlebot/ipv6.txt
- IPv6 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/googlebot/ipv6_merged.txt

To allow GoogleBot, block all Google IP addresses and then allow the GoogleBot addresses.

### Bing (Bingbot)

- IPv4: https://raw.githubusercontent.com/lord-alfred/ipranges/main/bing/ipv4.txt
- IPv4 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/bing/ipv4_merged.txt

### Amazon (AWS)

- IPv4: https://raw.githubusercontent.com/lord-alfred/ipranges/main/amazon/ipv4.txt
- IPv4 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/amazon/ipv4_merged.txt
- IPv6: https://raw.githubusercontent.com/lord-alfred/ipranges/main/amazon/ipv6.txt
- IPv6 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/amazon/ipv6_merged.txt

### Microsoft

- IPv4: https://raw.githubusercontent.com/lord-alfred/ipranges/main/microsoft/ipv4.txt
- IPv4 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/microsoft/ipv4_merged.txt
- IPv6: https://raw.githubusercontent.com/lord-alfred/ipranges/main/microsoft/ipv6.txt
- IPv6 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/microsoft/ipv6_merged.txt

### Oracle (Cloud)

- IPv4: https://raw.githubusercontent.com/lord-alfred/ipranges/main/oracle/ipv4.txt
- IPv4 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/oracle/ipv4_merged.txt

### DigitalOcean

- IPv4: https://raw.githubusercontent.com/lord-alfred/ipranges/main/digitalocean/ipv4.txt
- IPv4 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/digitalocean/ipv4_merged.txt
- IPv6: https://raw.githubusercontent.com/lord-alfred/ipranges/main/digitalocean/ipv6.txt
- IPv6 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/digitalocean/ipv6_merged.txt

### GitHub

- IPv4: https://raw.githubusercontent.com/lord-alfred/ipranges/main/github/ipv4.txt
- IPv4 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/github/ipv4_merged.txt
- IPv6: https://raw.githubusercontent.com/lord-alfred/ipranges/main/github/ipv6.txt
- IPv6 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/github/ipv6_merged.txt

### Facebook (Meta)

- IPv4: https://raw.githubusercontent.com/lord-alfred/ipranges/main/facebook/ipv4.txt
- IPv4 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/facebook/ipv4_merged.txt
- IPv6: https://raw.githubusercontent.com/lord-alfred/ipranges/main/facebook/ipv6.txt
- IPv6 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/facebook/ipv6_merged.txt

### Twitter

- IPv4: https://raw.githubusercontent.com/lord-alfred/ipranges/main/twitter/ipv4.txt
- IPv4 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/twitter/ipv4_merged.txt
- IPv6: https://raw.githubusercontent.com/lord-alfred/ipranges/main/twitter/ipv6.txt
- IPv6 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/twitter/ipv6_merged.txt

### Linode

- IPv4: https://raw.githubusercontent.com/lord-alfred/ipranges/main/linode/ipv4.txt
- IPv4 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/linode/ipv4_merged.txt
- IPv6: https://raw.githubusercontent.com/lord-alfred/ipranges/main/linode/ipv6.txt
- IPv6 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/linode/ipv6_merged.txt

### Telegram

- IPv4: https://raw.githubusercontent.com/lord-alfred/ipranges/main/telegram/ipv4.txt
- IPv4 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/telegram/ipv4_merged.txt
- IPv6: https://raw.githubusercontent.com/lord-alfred/ipranges/main/telegram/ipv6.txt
- IPv6 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/telegram/ipv6_merged.txt

### OpenAI (GPTBot)

- IPv4: https://raw.githubusercontent.com/lord-alfred/ipranges/main/openai/ipv4.txt
- IPv4 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/openai/ipv4_merged.txt

### CloudFlare

- IPv4: https://raw.githubusercontent.com/lord-alfred/ipranges/main/cloudflare/ipv4.txt
- IPv4 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/cloudflare/ipv4_merged.txt
- IPv6: https://raw.githubusercontent.com/lord-alfred/ipranges/main/cloudflare/ipv6.txt
- IPv6 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/cloudflare/ipv6_merged.txt

### Vultr

- IPv4: https://raw.githubusercontent.com/lord-alfred/ipranges/main/vultr/ipv4.txt
- IPv4 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/vultr/ipv4_merged.txt
- IPv6: https://raw.githubusercontent.com/lord-alfred/ipranges/main/vultr/ipv6.txt
- IPv6 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/vultr/ipv6_merged.txt

### Apple (Private Relay)

- IPv4: https://raw.githubusercontent.com/lord-alfred/ipranges/main/apple-proxy/ipv4.txt
- IPv4 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/apple-proxy/ipv4_merged.txt
- IPv6: https://raw.githubusercontent.com/lord-alfred/ipranges/main/apple-proxy/ipv6.txt
- IPv6 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/apple-proxy/ipv6_merged.txt

### ProtonVPN (exit nodes)

- IPv4: https://raw.githubusercontent.com/lord-alfred/ipranges/main/protonvpn/ipv4.txt
- IPv4 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/protonvpn/ipv4_merged.txt

### Perplexity 

- IPv4: https://raw.githubusercontent.com/lord-alfred/ipranges/main/perplexity/ipv4.txt
- IPv4 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/perplexity/ipv4_merged.txt

## All-In-One IPs

A list of IP addresses from all sources combined into one file.

- IPv4: https://raw.githubusercontent.com/lord-alfred/ipranges/main/all/ipv4.txt
- IPv4 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/all/ipv4_merged.txt
- IPv6: https://raw.githubusercontent.com/lord-alfred/ipranges/main/all/ipv6.txt
- IPv6 (merged): https://raw.githubusercontent.com/lord-alfred/ipranges/main/all/ipv6_merged.txt

## Friendly Repos

- Akamai: https://github.com/SecOps-Institute/Akamai-ASN-and-IPs-List
- LinkedIn: https://github.com/SecOps-Institute/LinkedInIPLists
- TOR: https://github.com/SecOps-Institute/Tor-IP-Addresses
- Spamhaus: https://github.com/SecOps-Institute/SpamhausIPLists
- Alibaba, Telegram and others: https://github.com/im-sm/Mikrotik-IP-List


## Author

Lord_Alfred

Blog (Russian language): [https://t.me/Lord_Alfred](https://t.me/Lord_Alfred)
